<?php
/**
 * Enqueue child styles.
 */
function child_enqueue_styles() {
	wp_enqueue_style( 'child-theme', get_stylesheet_directory_uri() . '/style.css', array(), 100 );
}

// add_action( 'wp_enqueue_scripts', 'child_enqueue_styles' ); // Remove the // from the beginning of this line if you want the child theme style.css file to load on the front end of your site.

/**
 * Add custom functions here
 */
add_action('init', 'inicializacion_web_pyme');
function inicializacion_web_pyme()
{
	// Impide que se carguen emojis
	remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
	remove_action( 'wp_print_styles', 'print_emoji_styles' );
	remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
	remove_action( 'admin_print_styles', 'print_emoji_styles' );
	// Impide conversion de caracteres
	add_filter( 'option_use_smilies', '__return_false' );
	// Desactiva oEmbed, script para incrustar post WordPress de otros sitios
	add_action( 'wp_footer', function (){wp_dequeue_script( 'wp-embed' );} );
	// Carga estilos y scipts para editor tinymce en descripciones de categorías
	add_action( 'admin_enqueue_scripts', 'carga_tinymce');
	// Ajusta algunos textos de plantilla Kadence y WooCommerce.
	add_filter( 'gettext', 'cambia_texto_por_favor', 999, 3 );
	// Inserta script que transforma área de texto en editor Tinymce en descripciones de categorías
	add_action('admin_head-term.php','tinymce_init');
	// Descativa el marcado automático de párrafos en widget de texto
	remove_filter('widget_text_content', 'wpautop');
	// Permite cargar archivos SVG.
		add_filter('upload_mimes', 'permite_svg' );
		// Crea shortcode para mostrar archivos SVG. Usa la función acaso_svg()
		add_shortcode( 'svg', function($adjunto){return acaso_svg($adjunto['id']);} );
		// Filtra el html de las imágenes adjuntas y devuelve el contenido cuando es svg. Usa la función acaso_svg()
		add_filter( 'wp_get_attachment_image', function ($html, $adjunto_id){return acaso_svg($adjunto_id)?acaso_svg($adjunto_id):$html;}, 10, 2);
		// Interviene el menú según id y lugar en la plantilla colocando imágenes miniautra a la izquierda.
		add_filter( 'nav_menu_item_args', 'pone_miniatura_en_menu', 10, 3);
		// Shortcode que despliega elcontenido de un bloque reutilizable
	add_shortcode( 'reusable', 'muestra_bloque_reutilizable' );
	// Previene la sanitización al guardar y al escapar html cuando encuentra el texto "[admin]"
	// en la cadena original (usado en botón cabecera).
	add_filter( 'sanitize_text_field', 'guarda_html',10, 2 );
	add_filter( 'esc_html', 'escapa_html',10, 2 );
	// Reemplaza buscador Kadence por Fibosearch
	remove_action('kadence_header_search', 'Kadence\header_search');
	add_action('kadence_header_search', function(){echo do_shortcode('[fibosearch]');}, 0);

	//add_action( 'kadence_bottom_header', function(){echo '<div class="site-container">'.wp_get_attachment_image(1682, 'thumbnail', false, ['class' => 'logo-asociado']).'</div>';}, 1 );
	add_action( 'kadence_site_branding', function(){echo wp_get_attachment_image(1682, 'thumbnail', false, ['class' => 'abajito']); }, 999 );
	add_action( 'kadence_mobile_site_branding', function(){echo wp_get_attachment_image(1682, [80, 20], false, ['class' => 'al-lado']); }, 999 );

	// Previene la sanitización al guardar y al escapar html en las descricpiones de términos de taxonomías
	remove_filter( 'pre_term_description', 'wp_filter_kses' );
	remove_filter( 'term_description', 'wp_kses_data' );
	// Inserta una tabla en lugar del loop eliminado en kadence-child/woocommerce/archive-product.php).
	add_action( 'woocommerce_archive_description', 'inserta_tabla');
	add_action( 'woocommerce_check_cart_items' , 'condicion_de_compra' );
	// Elimina las opciones de envío del carrito.
	add_filter( 'woocommerce_cart_ready_to_calc_shipping', function($muestra_envío){return is_cart()? false: $muestra_envío;}, 99 );
	// CHECKOUT - Ordena los datos de dirección (no se pueden ordenar con los otros hooks).
	add_filter( 'woocommerce_default_address_fields', 'ordena_datos_cliente' );
	// CHECKOUT - Alinear campos Checkout.
	add_filter( 'woocommerce_checkout_fields', 'diagramacion_campos_checkout', 9999 );
	// CHECKOUT - Crea formulario "Boleta o Factura".
	add_action( 'woocommerce_after_checkout_billing_form', 'boleta_o_factura' );
	// CHECKOUT -Agrega clases css a la sección "Boleta o Factura" para botones bonitos
	add_filter( 'woocommerce_form_field_radio', 'filter_woocommerce_form_field_radio', 10, 4 );
	// CHECKOUT - Carga javascript para que aprezca o desaparezca el formulario de factura.
	add_action( 'wp_enqueue_scripts', 'carga_js_opcion_factura' );
	// CHECKOUT - Si es con factura los campos son obligatorios.
	add_action( 'woocommerce_checkout_process', 'valida_boleta_o_factura' );
	// CHECKOUT - Adjunta los datos de facturación a la orden de compra.
	add_action( 'woocommerce_checkout_update_order_meta', 'boleta_o_factura_update_order_meta' );
	// Muestra los datos de facturación en editor de órdenes de compra.
	add_action( 'woocommerce_admin_order_data_after_billing_address', 'boleta_o_factura_display_admin_order_meta', 10, 1 );
	// Agrega las comunas de Chile al listado de WooComerce.
	add_filter('woocommerce_states', 'comunas_de_chile' );
}

add_action('kadence_header_button', 'aaa', 999);
function aaa()
{
	?>
	<div class="header-button-wrap"><div class="header-button-inner-wrap">
		<a href="tel:+56987802049" target="_self" class="button header-button button-size-custom button-style-outline">
			<div><span class"telefono-encabezado"=""><h4>(56) 9 8780 2049</h4></span></div>
		</a>
	</div></div>
	<?php
}
// Desactiva scripts estilos inútiles.
add_action('wp_enqueue_scripts', 'bota_basura' );
function bota_basura()
{
	wp_deregister_script('wp-mediaelement');
	wp_deregister_style('wp-mediaelement');
	wp_deregister_script('wp-util');
	wp_deregister_script('underscore');
	// Assets cargado por plugin de tablas no se usan en portada.
	if(is_front_page())
	{
		wp_dequeue_style( 'antiscroll' );
		wp_dequeue_style( 'freeze_table' );
		wp_dequeue_style( 'wcpt' );
		wp_dequeue_script( 'wcpt' );
		wp_dequeue_script( 'freeze_table' );
		wp_dequeue_script( 'antiscroll' );
	}
}

function carga_tinymce()
{
    if ( get_current_screen()->id == 'edit-product_cat' )
	{
		wp_enqueue_script('wp-tinymce');
		wp_enqueue_style( 'editor-buttons' );
	}
}

function tinymce_init()
{
	$code_path = get_stylesheet_directory_uri().'/tinymce-plugin/code/plugin.min.js';
    ?>
    <script>
	tinymce.init({
		selector: '#description',
		relative_urls:false,
		menubar: false,
  		plugins: [
			'fullscreen', 'image', 'charmap',
			'colorpicker', 'hr', 'lists',
			'media', 'paste', 'tabfocus',
			'textcolor', 'fullscreen', 'wordpress',
			'wpautoresize', 'wpeditimage', 'wpemoji',
			'wpgallery', 'wplink', 'wpdialogs',
			'wptextpattern', 'wpview', 'image',
			'code'
  		],
		external_plugins: { 'code': '<?php echo $code_path; ?>' },
		toolbar1:
			'formatselect bold italic bullist numlist blockquote alignleft aligncenter alignright link wp_more spellchecker wp_adv',
  		toolbar2:
			'strikethrough hr forecolor pastetext removeformat charmap outdent indent undo redo wp_add_media code',
      });
    </script>
    <?php
}

function escapa_html($segura, $original)
{
	return strpos( $original, '[admin]')!== false? do_shortcode(str_replace( '[admin]', '', $original)): $segura;
}

function guarda_html($segura, $original)
{
	return strpos( $original, '[admin]')!== false? $original: $segura;
}

function muestra_bloque_reutilizable( $atts )
{
	extract( shortcode_atts( array('id' => '' ), $atts ) );
    return (empty( $id ) || (int) $id !== $id)? null: get_post_field( 'post_content', $block_id );
}

function permite_svg($tipos_permitidos)
{
	$tipos_permitidos['svg'] = 'image/svg+xml';
	return $tipos_permitidos;
}

function acaso_svg($adjunto_id)
{
	$imagen_src = wp_get_attachment_url($adjunto_id);
	// Podría ser también get_post_mime_type( $adjunto_id )=='image/svg+xml'?
	return pathinfo($imagen_src, PATHINFO_EXTENSION)=='svg'?file_get_contents($imagen_src):false;
}

function pone_miniatura_en_menu($args, $item, $depth)
{
	// Para apuntar a una ubicación: $args->theme_location=='mobile-menu'.
	if (in_array($args->menu->term_id, [50]))
	{
		switch ($item->object)
		{
			case 'product_cat':
				// Imagen plugin "Taxonomy Images" https://es.wordpress.org/plugins/taxonomy-images/.
				// Para imagen "WooCommerce" por defecto es: get_term_meta($item->object_id, 'thumbnail_id', true).
				if (!empty(get_option( 'taxonomy_image_plugin' )[$item->object_id]))
				$adjunto_id = get_option( 'taxonomy_image_plugin' )[$item->object_id];
				break;
			case 'page':
				$adjunto_id = get_post_thumbnail_id($item->object_id);
				break;
			case 'pwb-brand':
				// Imagen plugin "Perfect Brands for WooCommerce" https://wordpress.org/plugins/perfect-woocommerce-brands/.
				$adjunto_id = get_term_meta($item->object_id, 'pwb_brand_image', true);
				break;
		}
		$args->link_before = $adjunto_id?wp_get_attachment_image($adjunto_id):wp_get_attachment_image(684);
	}
	return $args;
}

add_action('wp', 'ajustes_web_pyme' );
function ajustes_web_pyme(){
	// desactiva script Plugin Contact Form 7 excepto en la página de contacto
	if(!is_page('Contacto')) add_filter( 'wpcf7_load_js', '__return_false' );
	// desactiva estilos Plugin Contact Form 7 globalmente
	add_filter( 'wpcf7_load_css', '__return_false' );
}

function imagen_categoria()
{
	if (is_product_category())
	echo '<div class="imagen-categoria">'.wp_get_attachment_image( get_term_meta( get_queried_object_id(), 'thumbnail_id', 1 ), 'full' ).'</div>';
}

function cambia_texto_por_favor( $traducido, $original, $text_domain )
{
	if('woocommerce' === $text_domain)
	{
		switch ( $traducido )
		{
			case 'Detalles de facturación':
				$traducido = 'Datos del cliente';
			break;
		}
	}
	elseif('kadence' === $text_domain)
	{
		switch ($traducido)
		{
		case 'Resumen del carrito':
			$traducido = 'Tu carrito de compras';
		break;
		}
	}
	return $traducido;
}

function inserta_tabla()
{
	if(is_search())
	{
		global $wp_query;
		echo do_shortcode ( '[product_table name="Tabla productos" ids="' .implode(',', wp_list_pluck( $wp_query->posts, 'ID') ). '"]' );
	}
	elseif(is_product_category())
	{
		$categorias = get_terms(['taxonomy'=>'product_cat', 'child_of'=>get_queried_object_id()] );
		// Si no tiene hijos será la única categoría en el loop y si tiene hijos pone el título de la categoría padre.
		if (empty($categorias)) array_push($categorias, get_queried_object());
		else { ?><h1 class="categoria-padre-titulo"><?php echo get_queried_object()->name; ?></h1><?php }

		foreach ($categorias as $categoria)
		{
			?>
				<div id="<?php echo $categoria->slug; ?>" class="categoria-contenedor">
					<h2 class="categoria-titulo"><?php echo $categoria->name; ?></h2>
					<div class="categoria-contenido">
						<?php echo wp_get_attachment_image(get_term_meta($categoria->term_id, 'thumbnail_id', true), 'full', false, ['class'=>'categoria-imagen']); ?>
						<?php echo term_description($categoria->term_id); ?>
					</div>
					<?php echo do_shortcode ( '[product_table name="Tabla productos" category="' .$categoria->slug. '"]' ); ?>
				</div>
			<?php
		}
	}
}

//add_action('wp_head', 'info');
function info()
{
	global $enqueued_scripts;
    var_dump( $enqueued_scripts );
    global $enqueued_styles;
    var_dump(is_front_page(  ) );
}

/*
88b           d88                      88            88
888b         d888                      88            88
88`8b       d8'88                      88            88
88 `8b     d8' 88  ,adPPYba,   ,adPPYb,88  ,adPPYba, 88  ,adPPYba,
88  `8b   d8'  88 a8"     "8a a8"    `Y88 a8P_____88 88 a8"     "8a
88   `8b d8'   88 8b       d8 8b       88 8PP""""""" 88 8b       d8
88    `888'    88 "8a,   ,a8" "8a,   ,d88 "8b,   ,aa 88 "8a,   ,a8"
88     `8'     88  `"YbbdP"'   `"8bbdP"Y8  `"Ybbd8"' 88  `"YbbdP"'
*/

// Crear panel de información adicional en back-end
add_filter('woocommerce_product_data_tabs', 'pestana_nueva' );
function pestana_nueva($tabs)
{
	$tabs['info_adicional'] = [
		'label' => __('Información adicional', 'txtdomain'),
		'target' => 'informacion_adicional_producto',
		'class' => ['hide_if_external'],
		'priority' => 25
	];
	return $tabs;
}

// Crear campo "referencia" en pestaña nueva
add_action('woocommerce_product_data_panels', 'camporeferencia' );
function camporeferencia()
{
	?>
    <div id="informacion_adicional_producto" class="panel woocommerce_options_panel hidden">
  <?php
  	woocommerce_wp_text_input([
  		'id' => 'referencia',
  		'label' => __('Referencia', 'euroluz'),
  		//'wrapper_class' => 'show_if_simple', //clases ocultan o muestran según condiciones
  	]);
	?>
    </div>
  <?php
}

add_action('woocommerce_process_product_meta', 'guarda_referencia' );
function guarda_referencia($post_id)
{
  $product = wc_get_product($post_id);
  $data_referencia = isset($_POST['referencia']) ? $_POST['referencia'] : '';
  $product->update_meta_data('referencia', sanitize_text_field($data_referencia));
  $product->save();
}


//https://github.com/woocommerce/woocommerce/wiki/Product-CSV-Importer-&-Exporter#adding-custom-export-columns-developers

/**
 * Add the custom column to the exporter and the exporter column menu.
 *
 * @param array $columns
 * @return array $columns
 */
add_filter( 'woocommerce_product_export_column_names', 'inserta_columnas' );
add_filter( 'woocommerce_product_export_product_default_columns', 'inserta_columnas' );
function inserta_columnas( $columns ) {
	$columns[ 'referencia' ] = __( 'Referencia', 'euroluz' );
	return $columns;
}

/**
 * Provide the data to be exported for one item in the column.
 *
 * @param mixed $value (default: '')
 * @param WC_Product $product
 * @return mixed $value - Should be in a format that can be output into a text file (string, numeric, etc).
 */
add_filter( 'woocommerce_product_export_product_column_referencia', 'exporta_referencia', 10, 2 );
function exporta_referencia( $value, $product )
{
	return $product->get_meta('referencia');
}

/**
 * Register the 'Custom Column' column in the importer.
 *
 * @param array $options
 * @return array $options
 */
add_filter( 'woocommerce_csv_product_import_mapping_options', 'add_column_to_importer' );
function add_column_to_importer( $options )
{
	// column slug => column name
	$options['referencia'] = 'Referencia';

	return $options;
}

/**
 * Add automatic mapping support for 'Custom Column'.
 * This will automatically select the correct mapping for columns named 'Custom Column' or 'custom column'.
 *
 * @param array $columns
 * @return array $columns
 */
add_filter( 'woocommerce_csv_product_import_mapping_default_columns', 'add_column_to_mapping_screen' );
function add_column_to_mapping_screen( $columns )
{
	// potential column name => column slug
	$columns['Referencia'] = 'referencia';

	return $columns;
}

/**
 * Process the data read from the CSV file.
 * This just saves the value in meta data, but you can do anything you want here with the data.
 *
 * @param WC_Product $object - Product being imported or updated.
 * @param array $data - CSV data read for the product.
 * @return WC_Product $object
 */
add_filter( 'woocommerce_product_import_pre_insert_product_object', 'process_import', 10, 2 );
function process_import( $object, $data )
{
  if ( ! empty( $data['referencia'] ) )
  {
    $object->update_meta_data('referencia', sanitize_text_field($data['referencia']));
  }
  return $object;
}


function ordena_datos_cliente( $fields)
{
    $fields['state']['priority'] = 70;
    $fields['state']['class'] = array('form-row-first', 'address-field');
    $fields['city']['priority'] = 80;
    $fields['city']['class'] = array('form-row-last', 'address-field');
    $fields['address_1']['priority'] = 60;
    $fields['address_1']['class'] = array('form-row-wide', 'address-field');

    return $fields;
}

function diagramacion_campos_checkout( $fields )
{
	unset($fields['billing']['billing_postcode']);
	unset($fields['shipping']['shipping_postcode']);
	unset($fields['billing']['billing_company']);
	unset($fields['billing']['billing_address_2']);

	$fields['billing']['billing_phone']['class'] = array('form-row-first');
    $fields['billing']['billing_phone']['priority'] = 30;
	$fields['billing']['billing_email']['class'] = array('form-row-last');
	$fields['billing']['billing_email']['label'] = 'Email';
	$fields['billing']['billing_email']['priority'] = 40;

	$fields['billing']['billing_country']['priority'] = 50;
	$fields['billing']['billing_country']['class'] = array('form-row-wide', 'address-field');

    return $fields;
}

function boleta_o_factura($checkout)
{
    echo '<div id="seccion_opcion_boleta_o_factura"><h3>' . __('Documento') . '</h3>';
		echo '<div id="externo_radio_opcion_boleta_o_factura">';
			woocommerce_form_field( 'radio_opcion_boleta_o_factura', array(
				'type'          => 'radio',
				'class'         => array('my-field-class form-row-wide'),
				'label'         => __('Seleccione boleta o factura'),
				'options'   => array( 'boleta' => 'Boleta', 'factura' =>'Factura', ),
				'default'   => 'boleta',
				'required'    => true,
				), $checkout->get_value( 'radio_opcion_boleta_o_factura' ) );
		echo '</div>';

		echo('<div id="campos_opcion_factura">');
			woocommerce_form_field( 'razon_social_factura', array(
				'type'          => 'text',
				'class'         => array('my-field-class form-row-wide'),
				'label'         => __('Razón social'),
				'required'    => true,
				), $checkout->get_value( 'razon_social_factura' ) );
			woocommerce_form_field( 'rut_factura', array(
				'type'          => 'text',
				'class'         => array('my-field-class form-row-first'),
				'label'         => __('RUT'),
				'required'    => true,
				), $checkout->get_value( 'rut_factura' ) );
			woocommerce_form_field( 'giro_factura', array(
				'type'          => 'text',
				'class'         => array('my-field-class form-row-last'),
				'label'         => __('Giro'),
				'required'    => true,
				), $checkout->get_value( 'giro_factura' ) );
			woocommerce_form_field( 'direccion_factura', array(
				'type'          => 'text',
				'class'         => array('my-field-class form-row-wide'),
				'label'         => __('Dirección de facturación'),
				'required'    => true,
				), $checkout->get_value( 'direccion_factura' ) );
			woocommerce_form_field( 'comuna_factura', array(
				'type'          => 'text',
				'class'         => array('my-field-class form-row-first'),
				'label'         => __('Comuna'),
				'required'    => true,
				), $checkout->get_value( 'comuna_factura' ) );
			woocommerce_form_field( 'ciudad_factura', array(
				'type'          => 'text',
				'class'         => array('my-field-class form-row-last'),
				'label'         => __('Ciudad'),
				'required'    => true,
				), $checkout->get_value( 'ciudad_factura' ) );
		echo '</div>';
	echo '</div>';
}

function filter_woocommerce_form_field_radio($field, $key, $args, $value)
{
	if ($key=='radio_opcion_boleta_o_factura')
	{
		$nuevo='';
		if ( ! empty( $args['options'] ) ) {
			$n=0;
			foreach ( $args['options'] as $option_key => $option_text ) {
				$n += 1;
				$nuevo .= '<input type="radio" class="input-radio ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" value="' . esc_attr( $option_key ) . '" name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '_' . esc_attr( $option_key ) . '"' . checked( $value, $option_key, false ) . ' />';
				$nuevo .= '<label for="' . esc_attr( $args['id'] ) . '_' . esc_attr( $option_key ) . '" class="radio opcion opcion-' . $n . ' ' . implode( ' ', $args['label_class'] ) . '"><div class="dot"></div><span>' . esc_html( $option_text ) . '</span></label>';
			}
		}
		return $nuevo;
	}
	return $field;
}

function valida_boleta_o_factura($data)
{
	if( $_POST['radio_opcion_boleta_o_factura']!='boleta' && !($_POST['razon_social_factura'] || $_POST['rut_factura']|| $_POST['giro_factura']))
	{
		wc_add_notice( __( 'Por favor, llene los datos de facturación o seleccione "Boleta"' ), 'error' );
	}
	return $data;
}

function boleta_o_factura_update_order_meta( $order_id )
{
	update_post_meta( $order_id, 'Documento', sanitize_text_field( $_POST['radio_opcion_boleta_o_factura'] ) );

	if ( ! empty( $_POST['razon_social_factura'] ) ) update_post_meta( $order_id, 'Razón social', sanitize_text_field( $_POST['razon_social_factura'] ) );
	if ( ! empty( $_POST['rut_factura'] ) ) update_post_meta( $order_id, 'RUT', sanitize_text_field( $_POST['rut_factura'] ) );
	if ( ! empty( $_POST['giro_factura'] ) ) update_post_meta( $order_id, 'Giro', sanitize_text_field( $_POST['giro_factura'] ) );
	if ( ! empty( $_POST['direccion_factura'] ) ) update_post_meta( $order_id, 'Dirección de facturación', sanitize_text_field( $_POST['direccion_factura'] ) );
	if ( ! empty( $_POST['comuna_factura'] ) ) update_post_meta( $order_id, 'Comuna de facturación', sanitize_text_field( $_POST['comuna_factura'] ) );
	if ( ! empty( $_POST['ciudad_factura'] ) ) update_post_meta( $order_id, 'Ciudad de facturación', sanitize_text_field( $_POST['ciudad_factura'] ) );
}

function boleta_o_factura_display_admin_order_meta($order)
{
	echo '<p><strong>'.__('Documento').':</strong> ' . get_post_meta( $order->get_id(), 'Documento', true ) . '</p>';
	echo '<p><strong>'.__('Razón social').':</strong> ' . get_post_meta( $order->get_id(), 'Razón social', true ) . '</p>';
	echo '<p><strong>'.__('RUT').':</strong> ' . get_post_meta( $order->get_id(), 'RUT', true ) . '</p>';
	echo '<p><strong>'.__('Giro').':</strong> ' . get_post_meta( $order->get_id(), 'Giro', true ) . '</p>';
	echo '<p><strong>'.__('Dirección de facturación').':</strong> ' . get_post_meta( $order->get_id(), 'Dirección de facturación', true ) . '</p>';
	echo '<p><strong>'.__('Comuna de facturación').':</strong> ' . get_post_meta( $order->get_id(), 'Comuna de facturación', true ) . '</p>';
	echo '<p><strong>'.__('Ciudad de facturación').':</strong> ' . get_post_meta( $order->get_id(), 'Ciudad de facturación', true ) . '</p>';
}

function carga_js_opcion_factura()
{
	if (is_checkout())
	{
		wp_enqueue_script('boleta-o-factura', get_stylesheet_directory_uri(). '/js/boleta-o-factura.js', 'jquery');
	}
}

function reemplaza_state_por_comuna($locale)
{
	$locale['CL']['state']['label'] = __('Comuna', 'woocommerce');
	return $locale;
}

function comunas_de_chile($states) {
	$states['CL'] = array(
		'CL01101' => __( 'Iquique', 'woocommerce' ),
		'CL01107' => __( 'Alto Hospicio', 'woocommerce' ),
		'CL01401' => __( 'Pozo Almonte', 'woocommerce' ),
		'CL01402' => __( 'Camiña', 'woocommerce' ),
		'CL01403' => __( 'Colchane', 'woocommerce' ),
		'CL01404' => __( 'Huara', 'woocommerce' ),
		'CL01405' => __( 'Pica', 'woocommerce' ),
		'CL02101' => __( 'Antofagasta', 'woocommerce' ),
		'CL02102' => __( 'Mejillones', 'woocommerce' ),
		'CL02103' => __( 'Sierra Gorda', 'woocommerce' ),
		'CL02104' => __( 'Taltal', 'woocommerce' ),
		'CL02201' => __( 'Calama', 'woocommerce' ),
		'CL02202' => __( 'Ollagüe', 'woocommerce' ),
		'CL02203' => __( 'San Pedro de Atacama', 'woocommerce' ),
		'CL02301' => __( 'Tocopilla', 'woocommerce' ),
		'CL02302' => __( 'María Elena', 'woocommerce' ),
		'CL03101' => __( 'Copiapó', 'woocommerce' ),
		'CL03102' => __( 'Caldera', 'woocommerce' ),
		'CL03103' => __( 'Tierra Amarilla', 'woocommerce' ),
		'CL03201' => __( 'Chañaral', 'woocommerce' ),
		'CL03202' => __( 'Diego de Almagro', 'woocommerce' ),
		'CL03301' => __( 'Vallenar', 'woocommerce' ),
		'CL03302' => __( 'Alto del Carmen', 'woocommerce' ),
		'CL03303' => __( 'Freirina', 'woocommerce' ),
		'CL03304' => __( 'Huasco', 'woocommerce' ),
		'CL04101' => __( 'La Serena', 'woocommerce' ),
		'CL04102' => __( 'Coquimbo', 'woocommerce' ),
		'CL04103' => __( 'Andacollo', 'woocommerce' ),
		'CL04104' => __( 'La Higuera', 'woocommerce' ),
		'CL04105' => __( 'Paihuano', 'woocommerce' ),
		'CL04106' => __( 'Vicuña', 'woocommerce' ),
		'CL04201' => __( 'Illapel', 'woocommerce' ),
		'CL04202' => __( 'Canela', 'woocommerce' ),
		'CL04203' => __( 'Los Vilos', 'woocommerce' ),
		'CL04204' => __( 'Salamanca', 'woocommerce' ),
		'CL04301' => __( 'Ovalle', 'woocommerce' ),
		'CL04302' => __( 'Combarbalá', 'woocommerce' ),
		'CL04303' => __( 'Monte Patria', 'woocommerce' ),
		'CL04304' => __( 'Punitaqui', 'woocommerce' ),
		'CL04305' => __( 'Río Hurtado', 'woocommerce' ),
		'CL05101' => __( 'Valparaíso', 'woocommerce' ),
		'CL05102' => __( 'Casablanca', 'woocommerce' ),
		'CL05103' => __( 'Concón', 'woocommerce' ),
		'CL05104' => __( 'Juan Fernández', 'woocommerce' ),
		'CL05105' => __( 'Puchuncaví', 'woocommerce' ),
		'CL05107' => __( 'Quintero', 'woocommerce' ),
		'CL05109' => __( 'Viña del Mar', 'woocommerce' ),
		'CL05201' => __( 'Isla de Pascua', 'woocommerce' ),
		'CL05301' => __( 'Los Andes', 'woocommerce' ),
		'CL05302' => __( 'Calle Larga', 'woocommerce' ),
		'CL05303' => __( 'Rinconada', 'woocommerce' ),
		'CL05304' => __( 'San Esteban', 'woocommerce' ),
		'CL05401' => __( 'La Ligua', 'woocommerce' ),
		'CL05402' => __( 'Cabildo', 'woocommerce' ),
		'CL05403' => __( 'Papudo', 'woocommerce' ),
		'CL05404' => __( 'Petorca', 'woocommerce' ),
		'CL05405' => __( 'Zapallar', 'woocommerce' ),
		'CL05501' => __( 'Quillota', 'woocommerce' ),
		'CL05502' => __( 'La Calera', 'woocommerce' ),
		'CL05503' => __( 'Hijuelas', 'woocommerce' ),
		'CL05504' => __( 'La Cruz', 'woocommerce' ),
		'CL05506' => __( 'Nogales', 'woocommerce' ),
		'CL05601' => __( 'San Antonio', 'woocommerce' ),
		'CL05602' => __( 'Algarrobo', 'woocommerce' ),
		'CL05603' => __( 'Cartagena', 'woocommerce' ),
		'CL05604' => __( 'El Quisco', 'woocommerce' ),
		'CL05605' => __( 'El Tabo', 'woocommerce' ),
		'CL05606' => __( 'Santo Domingo', 'woocommerce' ),
		'CL05701' => __( 'San Felipe', 'woocommerce' ),
		'CL05702' => __( 'Catemu', 'woocommerce' ),
		'CL05703' => __( 'Llay-Llay', 'woocommerce' ),
		'CL05704' => __( 'Panquehue', 'woocommerce' ),
		'CL05705' => __( 'Putaendo', 'woocommerce' ),
		'CL05706' => __( 'Santa María', 'woocommerce' ),
		'CL05801' => __( 'Quilpué', 'woocommerce' ),
		'CL05802' => __( 'Limache', 'woocommerce' ),
		'CL05803' => __( 'Olmué', 'woocommerce' ),
		'CL05804' => __( 'Villa Alemana', 'woocommerce' ),
		'CL06101' => __( 'Rancagua', 'woocommerce' ),
		'CL06102' => __( 'Codegua', 'woocommerce' ),
		'CL06103' => __( 'Coinco', 'woocommerce' ),
		'CL06104' => __( 'Coltauco', 'woocommerce' ),
		'CL06105' => __( 'Doñihue', 'woocommerce' ),
		'CL06106' => __( 'Graneros', 'woocommerce' ),
		'CL06107' => __( 'Las Cabras', 'woocommerce' ),
		'CL06108' => __( 'Machalí', 'woocommerce' ),
		'CL06109' => __( 'Malloa', 'woocommerce' ),
		'CL06110' => __( 'Mostazal', 'woocommerce' ),
		'CL06111' => __( 'Olivar', 'woocommerce' ),
		'CL06112' => __( 'Peumo', 'woocommerce' ),
		'CL06113' => __( 'Pichidegua', 'woocommerce' ),
		'CL06114' => __( 'Quinta de Tilcoco', 'woocommerce' ),
		'CL06115' => __( 'Rengo', 'woocommerce' ),
		'CL06116' => __( 'Requínoa', 'woocommerce' ),
		'CL06117' => __( 'San Vicente', 'woocommerce' ),
		'CL06201' => __( 'Pichilemu', 'woocommerce' ),
		'CL06202' => __( 'La Estrella', 'woocommerce' ),
		'CL06203' => __( 'Litueche', 'woocommerce' ),
		'CL06204' => __( 'Marchihue', 'woocommerce' ),
		'CL06205' => __( 'Navidad', 'woocommerce' ),
		'CL06206' => __( 'Paredones', 'woocommerce' ),
		'CL06301' => __( 'San Fernando', 'woocommerce' ),
		'CL06302' => __( 'Chépica', 'woocommerce' ),
		'CL06303' => __( 'Chimbarongo', 'woocommerce' ),
		'CL06304' => __( 'Lolol', 'woocommerce' ),
		'CL06305' => __( 'Nancagua', 'woocommerce' ),
		'CL06306' => __( 'Palmilla', 'woocommerce' ),
		'CL06307' => __( 'Peralillo', 'woocommerce' ),
		'CL06308' => __( 'Placilla', 'woocommerce' ),
		'CL06309' => __( 'Pumanque', 'woocommerce' ),
		'CL06310' => __( 'Santa Cruz', 'woocommerce' ),
		'CL07101' => __( 'Talca', 'woocommerce' ),
		'CL07102' => __( 'Constitución', 'woocommerce' ),
		'CL07103' => __( 'Curepto', 'woocommerce' ),
		'CL07104' => __( 'Empedrado', 'woocommerce' ),
		'CL07105' => __( 'Maule', 'woocommerce' ),
		'CL07106' => __( 'Pelarco', 'woocommerce' ),
		'CL07107' => __( 'Pencahue', 'woocommerce' ),
		'CL07108' => __( 'Río Claro', 'woocommerce' ),
		'CL07109' => __( 'San Clemente', 'woocommerce' ),
		'CL07110' => __( 'San Rafael', 'woocommerce' ),
		'CL07201' => __( 'Cauquenes', 'woocommerce' ),
		'CL07202' => __( 'Chanco', 'woocommerce' ),
		'CL07203' => __( 'Pelluhue', 'woocommerce' ),
		'CL07301' => __( 'Curicó', 'woocommerce' ),
		'CL07302' => __( 'Hualañé', 'woocommerce' ),
		'CL07303' => __( 'Licantén', 'woocommerce' ),
		'CL07304' => __( 'Molina', 'woocommerce' ),
		'CL07305' => __( 'Rauco', 'woocommerce' ),
		'CL07306' => __( 'Romeral', 'woocommerce' ),
		'CL07307' => __( 'Sagrada Familia', 'woocommerce' ),
		'CL07308' => __( 'Teno', 'woocommerce' ),
		'CL07309' => __( 'Vichuquén', 'woocommerce' ),
		'CL07401' => __( 'Linares', 'woocommerce' ),
		'CL07402' => __( 'Colbún', 'woocommerce' ),
		'CL07403' => __( 'Longaví', 'woocommerce' ),
		'CL07404' => __( 'Parral', 'woocommerce' ),
		'CL07405' => __( 'Retiro', 'woocommerce' ),
		'CL07406' => __( 'San Javier', 'woocommerce' ),
		'CL07407' => __( 'Villa Alegre', 'woocommerce' ),
		'CL07408' => __( 'Yerbas Buenas', 'woocommerce' ),
		'CL08101' => __( 'Concepción', 'woocommerce' ),
		'CL08102' => __( 'Coronel', 'woocommerce' ),
		'CL08103' => __( 'Chiguayante', 'woocommerce' ),
		'CL08104' => __( 'Florida', 'woocommerce' ),
		'CL08105' => __( 'Hualqui', 'woocommerce' ),
		'CL08106' => __( 'Lota', 'woocommerce' ),
		'CL08107' => __( 'Penco', 'woocommerce' ),
		'CL08108' => __( 'San Pedro de La Paz', 'woocommerce' ),
		'CL08109' => __( 'Santa Juana', 'woocommerce' ),
		'CL08110' => __( 'Talcahuano', 'woocommerce' ),
		'CL08111' => __( 'Tomé', 'woocommerce' ),
		'CL08112' => __( 'Hualpén', 'woocommerce' ),
		'CL08201' => __( 'Lebu', 'woocommerce' ),
		'CL08202' => __( 'Arauco', 'woocommerce' ),
		'CL08203' => __( 'Cañete', 'woocommerce' ),
		'CL08204' => __( 'Contulmo', 'woocommerce' ),
		'CL08205' => __( 'Curanilahue', 'woocommerce' ),
		'CL08206' => __( 'Los Álamos', 'woocommerce' ),
		'CL08207' => __( 'Tirúa', 'woocommerce' ),
		'CL08301' => __( 'Los Ángeles', 'woocommerce' ),
		'CL08302' => __( 'Antuco', 'woocommerce' ),
		'CL08303' => __( 'Cabrero', 'woocommerce' ),
		'CL08304' => __( 'Laja', 'woocommerce' ),
		'CL08305' => __( 'Mulchén', 'woocommerce' ),
		'CL08306' => __( 'Nacimiento', 'woocommerce' ),
		'CL08307' => __( 'Negrete', 'woocommerce' ),
		'CL08308' => __( 'Quilaco', 'woocommerce' ),
		'CL08309' => __( 'Quilleco', 'woocommerce' ),
		'CL08310' => __( 'San Rosendo', 'woocommerce' ),
		'CL08311' => __( 'Santa Bárbara', 'woocommerce' ),
		'CL08312' => __( 'Tucapel', 'woocommerce' ),
		'CL08313' => __( 'Yumbel', 'woocommerce' ),
		'CL08314' => __( 'Alto Biobío', 'woocommerce' ),
		'CL09101' => __( 'Temuco', 'woocommerce' ),
		'CL09102' => __( 'Carahue', 'woocommerce' ),
		'CL09103' => __( 'Cunco', 'woocommerce' ),
		'CL09104' => __( 'Curarrehue', 'woocommerce' ),
		'CL09105' => __( 'Freire', 'woocommerce' ),
		'CL09106' => __( 'Galvarino', 'woocommerce' ),
		'CL09107' => __( 'Gorbea', 'woocommerce' ),
		'CL09108' => __( 'Lautaro', 'woocommerce' ),
		'CL09109' => __( 'Loncoche', 'woocommerce' ),
		'CL09110' => __( 'Melipeuco', 'woocommerce' ),
		'CL09111' => __( 'Nueva Imperial', 'woocommerce' ),
		'CL09112' => __( 'Padre Las Casas', 'woocommerce' ),
		'CL09113' => __( 'Perquenco', 'woocommerce' ),
		'CL09114' => __( 'Pitrufquén', 'woocommerce' ),
		'CL09115' => __( 'Pucón', 'woocommerce' ),
		'CL09116' => __( 'Saavedra', 'woocommerce' ),
		'CL09117' => __( 'Teodoro Schmidt', 'woocommerce' ),
		'CL09118' => __( 'Toltén', 'woocommerce' ),
		'CL09119' => __( 'Vilcún', 'woocommerce' ),
		'CL09120' => __( 'Villarrica', 'woocommerce' ),
		'CL09121' => __( 'Cholchol', 'woocommerce' ),
		'CL09201' => __( 'Angol', 'woocommerce' ),
		'CL09202' => __( 'Collipulli', 'woocommerce' ),
		'CL09203' => __( 'Curacautín', 'woocommerce' ),
		'CL09204' => __( 'Ercilla', 'woocommerce' ),
		'CL09205' => __( 'Lonquimay', 'woocommerce' ),
		'CL09206' => __( 'Los Sauces', 'woocommerce' ),
		'CL09207' => __( 'Lumaco', 'woocommerce' ),
		'CL09208' => __( 'Purén', 'woocommerce' ),
		'CL09209' => __( 'Renaico', 'woocommerce' ),
		'CL09210' => __( 'Traiguén', 'woocommerce' ),
		'CL09211' => __( 'Victoria', 'woocommerce' ),
		'CL10101' => __( 'Puerto Montt', 'woocommerce' ),
		'CL10102' => __( 'Calbuco', 'woocommerce' ),
		'CL10103' => __( 'Cochamó', 'woocommerce' ),
		'CL10104' => __( 'Fresia', 'woocommerce' ),
		'CL10105' => __( 'Frutillar', 'woocommerce' ),
		'CL10106' => __( 'Los Muermos', 'woocommerce' ),
		'CL10107' => __( 'Llanquihue', 'woocommerce' ),
		'CL10108' => __( 'Maullín', 'woocommerce' ),
		'CL10109' => __( 'Puerto Varas', 'woocommerce' ),
		'CL10201' => __( 'Castro', 'woocommerce' ),
		'CL10202' => __( 'Ancud', 'woocommerce' ),
		'CL10203' => __( 'Chonchi', 'woocommerce' ),
		'CL10204' => __( 'Curaco de Vélez', 'woocommerce' ),
		'CL10205' => __( 'Dalcahue', 'woocommerce' ),
		'CL10206' => __( 'Puqueldón', 'woocommerce' ),
		'CL10207' => __( 'Queilén', 'woocommerce' ),
		'CL10208' => __( 'Quellón', 'woocommerce' ),
		'CL10209' => __( 'Quemchi', 'woocommerce' ),
		'CL10210' => __( 'Quinchao', 'woocommerce' ),
		'CL10301' => __( 'Osorno', 'woocommerce' ),
		'CL10302' => __( 'Puerto Octay', 'woocommerce' ),
		'CL10303' => __( 'Purranque', 'woocommerce' ),
		'CL10304' => __( 'Puyehue', 'woocommerce' ),
		'CL10305' => __( 'Río Negro', 'woocommerce' ),
		'CL10306' => __( 'San Juan de la Costa', 'woocommerce' ),
		'CL10307' => __( 'San Pablo', 'woocommerce' ),
		'CL10401' => __( 'Chaitén', 'woocommerce' ),
		'CL10402' => __( 'Futaleufú', 'woocommerce' ),
		'CL10403' => __( 'Hualaihué', 'woocommerce' ),
		'CL10404' => __( 'Palena', 'woocommerce' ),
		'CL11101' => __( 'Coyhaique', 'woocommerce' ),
		'CL11102' => __( 'Lago Verde', 'woocommerce' ),
		'CL11201' => __( 'Aysén', 'woocommerce' ),
		'CL11202' => __( 'Cisnes', 'woocommerce' ),
		'CL11203' => __( 'Guaitecas', 'woocommerce' ),
		'CL11301' => __( 'Cochrane', 'woocommerce' ),
		'CL11302' => __( "O'Higgins", 'woocommerce' ),
		'CL11303' => __( 'Tortel', 'woocommerce' ),
		'CL11401' => __( 'Chile Chico', 'woocommerce' ),
		'CL11402' => __( 'Río Ibáñez', 'woocommerce' ),
		'CL12101' => __( 'Punta Arenas', 'woocommerce' ),
		'CL12102' => __( 'Laguna Blanca', 'woocommerce' ),
		'CL12103' => __( 'Río Verde', 'woocommerce' ),
		'CL12104' => __( 'San Gregorio', 'woocommerce' ),
		'CL12201' => __( 'Cabo de Hornos', 'woocommerce' ),
		'CL12202' => __( 'Antártica', 'woocommerce' ),
		'CL12301' => __( 'Porvenir', 'woocommerce' ),
		'CL12302' => __( 'Primavera', 'woocommerce' ),
		'CL12303' => __( 'Timaukel', 'woocommerce' ),
		'CL12401' => __( 'Natales', 'woocommerce' ),
		'CL12402' => __( 'Torres del Paine', 'woocommerce' ),
		'CL13101' => __( 'Santiago', 'woocommerce' ),
		'CL13102' => __( 'Cerrillos', 'woocommerce' ),
		'CL13103' => __( 'Cerro Navia', 'woocommerce' ),
		'CL13104' => __( 'Conchalí', 'woocommerce' ),
		'CL13105' => __( 'El Bosque', 'woocommerce' ),
		'CL13106' => __( 'Estación Central', 'woocommerce' ),
		'CL13107' => __( 'Huechuraba', 'woocommerce' ),
		'CL13108' => __( 'Independencia', 'woocommerce' ),
		'CL13109' => __( 'La Cisterna', 'woocommerce' ),
		'CL13110' => __( 'La Florida', 'woocommerce' ),
		'CL13111' => __( 'La Granja', 'woocommerce' ),
		'CL13112' => __( 'La Pintana', 'woocommerce' ),
		'CL13113' => __( 'La Reina', 'woocommerce' ),
		'CL13114' => __( 'Las Condes', 'woocommerce' ),
		'CL13115' => __( 'Lo Barnechea', 'woocommerce' ),
		'CL13116' => __( 'Lo Espejo', 'woocommerce' ),
		'CL13117' => __( 'Lo Prado', 'woocommerce' ),
		'CL13118' => __( 'Macul', 'woocommerce' ),
		'CL13119' => __( 'Maipú', 'woocommerce' ),
		'CL13120' => __( 'Ñuñoa', 'woocommerce' ),
		'CL13121' => __( 'Pedro Aguirre Cerda', 'woocommerce' ),
		'CL13122' => __( 'Peñalolén', 'woocommerce' ),
		'CL13123' => __( 'Providencia', 'woocommerce' ),
		'CL13124' => __( 'Pudahuel', 'woocommerce' ),
		'CL13125' => __( 'Quilicura', 'woocommerce' ),
		'CL13126' => __( 'Quinta Normal', 'woocommerce' ),
		'CL13127' => __( 'Recoleta', 'woocommerce' ),
		'CL13128' => __( 'Renca', 'woocommerce' ),
		'CL13129' => __( 'San Joaquín', 'woocommerce' ),
		'CL13130' => __( 'San Miguel', 'woocommerce' ),
		'CL13131' => __( 'San Ramón', 'woocommerce' ),
		'CL13132' => __( 'Vitacura', 'woocommerce' ),
		'CL13201' => __( 'Puente Alto', 'woocommerce' ),
		'CL13202' => __( 'Pirque', 'woocommerce' ),
		'CL13203' => __( 'San José de Maipo', 'woocommerce' ),
		'CL13301' => __( 'Colina', 'woocommerce' ),
		'CL13302' => __( 'Lampa', 'woocommerce' ),
		'CL13303' => __( 'Til Til', 'woocommerce' ),
		'CL13401' => __( 'San Bernardo', 'woocommerce' ),
		'CL13402' => __( 'Buin', 'woocommerce' ),
		'CL13403' => __( 'Calera de Tango', 'woocommerce' ),
		'CL13404' => __( 'Paine', 'woocommerce' ),
		'CL13501' => __( 'Melipilla', 'woocommerce' ),
		'CL13502' => __( 'Alhué', 'woocommerce' ),
		'CL13503' => __( 'Curacaví', 'woocommerce' ),
		'CL13504' => __( 'María Pinto', 'woocommerce' ),
		'CL13505' => __( 'San Pedro', 'woocommerce' ),
		'CL13601' => __( 'Talagante', 'woocommerce' ),
		'CL13602' => __( 'El Monte', 'woocommerce' ),
		'CL13603' => __( 'Isla de Maipo', 'woocommerce' ),
		'CL13604' => __( 'Padre Hurtado', 'woocommerce' ),
		'CL13605' => __( 'Peñaflor', 'woocommerce' ),
		'CL14101' => __( 'Valdivia', 'woocommerce' ),
		'CL14102' => __( 'Corral', 'woocommerce' ),
		'CL14103' => __( 'Lanco', 'woocommerce' ),
		'CL14104' => __( 'Los Lagos', 'woocommerce' ),
		'CL14105' => __( 'Máfil', 'woocommerce' ),
		'CL14106' => __( 'Mariquina', 'woocommerce' ),
		'CL14107' => __( 'Paillaco', 'woocommerce' ),
		'CL14108' => __( 'Panguipulli', 'woocommerce' ),
		'CL14201' => __( 'La Unión', 'woocommerce' ),
		'CL14202' => __( 'Futrono', 'woocommerce' ),
		'CL14203' => __( 'Lago Ranco', 'woocommerce' ),
		'CL14204' => __( 'Río Bueno', 'woocommerce' ),
		'CL15101' => __( 'Arica', 'woocommerce' ),
		'CL15102' => __( 'Camarones', 'woocommerce' ),
		'CL15201' => __( 'Putre', 'woocommerce' ),
		'CL15202' => __( 'General Lagos', 'woocommerce' ),
		'CL16101' => __( 'Chillán', 'woocommerce' ),
		'CL16102' => __( 'Bulnes', 'woocommerce' ),
		'CL16103' => __( 'Chillán Viejo', 'woocommerce' ),
		'CL16104' => __( 'El Carmen', 'woocommerce' ),
		'CL16105' => __( 'Pemuco', 'woocommerce' ),
		'CL16106' => __( 'Pinto', 'woocommerce' ),
		'CL16107' => __( 'Quillón', 'woocommerce' ),
		'CL16108' => __( 'San Ignacio', 'woocommerce' ),
		'CL16109' => __( 'Yungay', 'woocommerce' ),
		'CL16201' => __( 'Quirihue', 'woocommerce' ),
		'CL16202' => __( 'Cobquecura', 'woocommerce' ),
		'CL16203' => __( 'Coelemu', 'woocommerce' ),
		'CL16204' => __( 'Ninhue', 'woocommerce' ),
		'CL16205' => __( 'Portezuelo', 'woocommerce' ),
		'CL16206' => __( 'Ránquil', 'woocommerce' ),
		'CL16207' => __( 'Treguaco', 'woocommerce' ),
		'CL16301' => __( 'San Carlos', 'woocommerce' ),
		'CL16302' => __( 'Coihueco', 'woocommerce' ),
		'CL16303' => __( 'Ñiquén', 'woocommerce' ),
		'CL16304' => __( 'San Fabián', 'woocommerce' ),
		'CL16305' => __( 'San Nicolás', 'woocommerce' ),

	);
	return $states;
}
